USE [enter DAX09 DATABASE NAME here]
GO


CREATE TRIGGER [dbo].[AdminUserGroupCheck]
ON [dbo].[USERGROUPLIST]
AFTER INSERT, UPDATE
AS

/*-----------------------------------------------------------------------------------
  * Script Name    : Admin User Group Check Setup.sql
  * Description    : Creates a database trigger on 'USERGROUPLIST' to check for when  
  *                  the 'Admin' Group is assigned to a user
  * Created By     : D.Coupland
  * Created Date   : 12/05/10
  * AX Environment : 
  * SQL Server     : 
  * Database	   : 
  * Notes          :  ** Replace the following with your environment details (TIP: use Find and Replace): ** 
						<enter SQL SERVER INSTANCE NAME here> = SQL Server Instance Name
						<enter DAX09 DATABASE NAME here> = Dynamics AX Database Name
						<enter PRODUCTION DATABASE NAME here>  =  Dynamics AX Database Name 
						<enter SQL SERVER DATABASE MAIL PROFILE NAME here>  = SQL SERVER DATABASE MAIL PROFILE NAME
						<enter RECIPIENTS EMAIL ADDRESSES here>  =  Reciepient Email addresses of users to recieve notifications
						<enter CC RECIPIENTS EMAILED ADDRESSES here>  =  CC Email addresses of users to recieve notifications
  *
  -----------------------------------------------------------------------------------
*/

-- Declare Variables
DECLARE	@UserId varchar(10),
		@UserName varchar(50),
		@ModifiedDate varchar(19),
		@ModifiedBy varchar(50),
		@EmailBody varchar(max),
		@ServerName varchar(30),
		@DbName varchar(20)
		
-- Get Database Instance Name
SET @ServerName = CONVERT(CHAR(100), SERVERPROPERTY('Servername'))

-- SET Database Name depending on Instance 
-- This enables the script to be used on Production & Non-Production environments and also
-- means when the Production DB is restored to a Non-Production environment it will notify if required.
-- Mutiple instances (Prod or Non-Prod) can be added into the CASE statement
SET @DbName = CASE 
				WHEN @ServerName = '<enter SQL SERVER INSTANCE NAME here>' THEN '<enter DAX09 DATABASE NAME here>'
			
			--  EXAMPLE
			--  WHEN @ServerName = 'MYSQLSERVER\MYINSTANCENAME' THEN 'DAX09_PROD' -- Production
			--  WHEN @ServerName = 'MYSQLSERVER2\MYINSTANCENAME2' THEN 'DAX09_TEST' -- Test

	
			  END

-- Production Environment

    IF  (SELECT GROUPID
            FROM INSERTED) = 'Admin' AND @DbName = '<enter PRODUCTION DATABASE NAME here>'
		BEGIN
			SET @UserId = (SELECT userid FROM INSERTED)
	
			SET @UserName = (SELECT ui.name FROM INSERTED i INNER JOIN
							<enter PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
							on i.userid = UI.id)
							 
			SET @ModifiedDate = (SELECT modifieddatetime FROM INSERTED)					
						
			SET @ModifiedBy = (SELECT ui.name FROM INSERTED i INNER JOIN 
						<enter PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
							on i.modifiedby = UI.id)

			SET	@EmailBody = 'Admin User Group Access Notification:' + CHAR(13) + CHAR(13)+ @UserName + ' (' + @UserId + ') ' + 'has been added as an ''Admin'' User in the ''LIVE'' Environment, by ' + @ModifiedBy + ' on ' + @ModifiedDate + ' (GMT).'

			EXEC msdb.dbo.sp_send_dbmail
			@profile_name = '<enter SQL SERVER DATABASE MAIL PROFILE NAME here>',
			@recipients = '<enter RECIPIENTS EMAIL ADDRESSES here>',
			@copy_recipients = '<enter CC RECIPIENTS EMAILED ADDRESSES here>',
			@body = @EmailBody,
			@subject = 'Admin User Group Access Notification'; 	
	
		END 
   
   
       IF  (SELECT GROUPID
            FROM INSERTED) = 'All' AND @DbName = '<enter PRODUCTION DATABASE NAME here>'
		BEGIN
			SET @UserId = (SELECT userid FROM INSERTED)
	
			SET @UserName = (SELECT ui.name FROM INSERTED i INNER JOIN
							<enter PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
							on i.userid = UI.id)
							 
			SET @ModifiedDate = (SELECT modifieddatetime FROM INSERTED)					
						
			SET @ModifiedBy = (SELECT ui.name FROM INSERTED i INNER JOIN 
						<enter PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
							on i.modifiedby = UI.id)

			SET	@EmailBody = 'All User Group Access Notification:' + CHAR(13) + CHAR(13)+ @UserName + ' (' + @UserId + ') ' + 'has been added as an ''All'' User in the ''LIVE'' Environment, by ' + @ModifiedBy + ' on ' + @ModifiedDate + ' (GMT).'

			EXEC msdb.dbo.sp_send_dbmail
			@profile_name = '<enter SQL SERVER DATABASE MAIL PROFILE NAME here>',
			@recipients = '<enter RECIPIENTS EMAIL ADDRESSES here>',
			@copy_recipients = '<enter CC RECIPIENTS EMAILED ADDRESSES here>',
			@body = @EmailBody,
			@subject = 'All User Group Access Notification'; 	
	
		END      

       
/* If the requirement is for your non-production environments or multiple environments to be monitored also you can make multiple copies of the code below uncomment the code below between the placeholders 
	** UNCOMMENT START ** & ** UNCOMMENT END ** 
   Then Replace the following with your environment details (TIP: use Find and Replace): 
						<enter NON-PRODUCTION DATABASE NAME here>  =  Non-Production Dynamics AX Database Name 
						<enter NON-PROD SQL SERVER DATABASE MAIL PROFILE NAME here>  = SQL SERVER DATABASE MAIL PROFILE NAME
						<enter RECIPIENTS EMAIL ADDRESSES here>  =  Reciepient Email addresses of users to recieve notifications
						<enter CC RECIPIENTS EMAILED ADDRESSES here>  =  CC Email addresses of users to recieve notifications
						<enter YOUR ENVIRONMENT NAME here> = Non-Production Environment Name (e.g. TEST, DEV etc.)
*/

-- Non-Production Environment (TEST)
-- ** UNCOMMENT START **

	--IF  (SELECT GROUPID
 --           FROM INSERTED) = 'Admin' AND @DbName = '<enter NON-PRODUCTION DATABASE NAME here>'
	--	BEGIN
	--		SET @UserId = (SELECT userid FROM INSERTED)
	
	--		SET @UserName = (SELECT ui.name FROM INSERTED i INNER JOIN
	--						<enter NON-PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
	--						on i.userid = UI.id)
							 
	--		SET @ModifiedDate = (SELECT modifieddatetime FROM INSERTED)					
						
	--		SET @ModifiedBy = (SELECT ui.name FROM INSERTED i INNER JOIN 
	--					<enter NON-PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
	--						on i.modifiedby = UI.id)

	--		SET	@EmailBody = 'Admin User Group Access Notification:' + CHAR(13) + CHAR(13)+ @UserName + ' (' + @UserId + ') ' + 'has been added as an ''Admin'' User in the ''<enter YOUR ENVIRONMENT NAME here>'' Environment, by ' + @ModifiedBy + ' on ' + @ModifiedDate + ' (GMT).'

	--		EXEC msdb.dbo.sp_send_dbmail
			--@profile_name = '<enter NON-PROD SQL SERVER DATABASE MAIL PROFILE NAME here>',
			--@recipients = '<enter RECIPIENTS EMAIL ADDRESSES here>',
			--@copy_recipients = '<enter CC RECIPIENTS EMAILED ADDRESSES here>',
	--		@body = @EmailBody,
	--		@subject = 'Admin User Group Access Notification'; 	
	
	--	END         

  --     IF  (SELECT GROUPID
  --          FROM INSERTED) = 'All' AND @DbName = '<enter NON-PRODUCTION DATABASE NAME here>'
		--BEGIN
		--	SET @UserId = (SELECT userid FROM INSERTED)
	
		--	SET @UserName = (SELECT ui.name FROM INSERTED i INNER JOIN
		--					<enter NON-PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
		--					on i.userid = UI.id)
							 
		--	SET @ModifiedDate = (SELECT modifieddatetime FROM INSERTED)					
						
		--	SET @ModifiedBy = (SELECT ui.name FROM INSERTED i INNER JOIN 
		--				<enter NON-PRODUCTION DATABASE NAME here>.dbo.USERINFO UI 
		--					on i.modifiedby = UI.id)

		--	SET	@EmailBody = 'All User Group Access Notification:' + CHAR(13) + CHAR(13)+ @UserName + ' (' + @UserId + ') ' + 'has been added as an ''All'' User in the ''<enter YOUR ENVIRONMENT NAME here>'' Environment, by ' + @ModifiedBy + ' on ' + @ModifiedDate + ' (GMT).'

		--	EXEC msdb.dbo.sp_send_dbmail
		--	@profile_name = '<enter NON-PROD SQL SERVER DATABASE MAIL PROFILE NAME here>',
		--	@recipients = '<enter RECIPIENTS EMAIL ADDRESSES here>',
		--	@copy_recipients = '<enter CC RECIPIENTS EMAILED ADDRESSES here>',
		--	@body = @EmailBody,
		--	@subject = 'All User Group Access Notification'; 	
	
		--END 
		
-- ** UNCOMMENT END **

GO


